/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.villagers.json.adapters;

import com.google.gson.JsonObject;
import com.nyfaria.numismaticoverhaul.currency.CurrencyHelper;
import com.nyfaria.numismaticoverhaul.villagers.exceptions.DeserializationException;
import com.nyfaria.numismaticoverhaul.villagers.json.TradeJsonAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.NumOTrade;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SellSusStewAdapter
extends TradeJsonAdapter {
    @Override
    @NotNull
    public VillagerTrades.ItemListing deserialize(JsonObject json) {
        this.loadDefaultStats(json, true);
        int price = json.get("price").getAsInt();
        int duration = GsonHelper.m_13824_((JsonObject)json, (String)"duration", (int)100);
        ResourceLocation effectId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"effect_id"));
        MobEffect effect = (MobEffect)Registry.f_122823_.m_6612_(effectId).orElseThrow(() -> new DeserializationException("Unknown status effect '" + effectId + "'"));
        return new Factory(effect, price, duration, this.villager_experience, this.price_multiplier, this.max_uses);
    }

    static class Factory
    implements VillagerTrades.ItemListing,
    NumOTrade {
        private final MobEffect effect;
        private final int price;
        private final int duration;
        private final int experience;
        private final int maxUses;
        private final float multiplier;

        public Factory(MobEffect effect, int price, int duration, int experience, float multiplier, int maxUses) {
            this.effect = effect;
            this.price = price;
            this.duration = duration;
            this.experience = experience;
            this.multiplier = multiplier;
            this.maxUses = maxUses;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack susStew = new ItemStack((ItemLike)Items.f_42718_, 1);
            SuspiciousStewItem.m_43258_((ItemStack)susStew, (MobEffect)this.effect, (int)this.duration);
            return new MerchantOffer(CurrencyHelper.getClosest(this.price), susStew, this.maxUses, this.experience, this.multiplier);
        }
    }
}

